package chess4j.board;

public enum Rank {
	RANK_8(0,"8"),
	RANK_7(1,"7"),
	RANK_6(2,"6"),
	RANK_5(3,"5"),
	RANK_4(4,"4"),
	RANK_3(5,"3"),
	RANK_2(6,"2"),
	RANK_1(7,"1");

	private int _value;
	private String _label;
	
	private Rank(int value,String label) {
		_value=value;
		_label=label;
	}

	public static Rank rank(int value) {
		for (Rank r : Rank.values()) {
			if (r.getValue()==value) {
				return r;
			}
		}
		throw new IllegalArgumentException("Rank value not found: " + value);
	}
	
	public static Rank rank(String value) {
		for (Rank r : Rank.values()) {
			if (r.getLabel().equalsIgnoreCase(value)) {
				return r;
			}
		}
		throw new IllegalArgumentException("Rank value not found: " + value);
	}
	
	public int distance(Rank r) {
		return Math.abs(r.getValue()-getValue());
	}
	
	public boolean equals(Rank r) {
		if (r==null) return false;
		return r.getValue()==_value;
	}
	
	public Rank flip() {
		return Rank.rank(7-_value);
	}
	
	public String getLabel() {
		return _label;
	}
	
	public int getValue() {
		return _value;
	}

	public boolean isPromotionRank() {
		return _value==RANK_1.getValue() || _value==RANK_8.getValue();
	}
	
	public Rank north() {
		if (_value==0) return null;
		return rank(_value-1);
	}
	
	public boolean northOf(Rank r) {
		return this.getValue() < r.getValue();
	}
	
	public Rank south() {
		if (_value==7) return null;
		return rank(_value+1);
	}
	
	public boolean southOf(Rank r) {
		return this.getValue() > r.getValue();
	}

	public static void main(String args[]) {
		for (Rank r : Rank.values()) {
			System.out.println(r + " " + r.getLabel() +
					" " + r.north() + " " + r.south());
		}
	}
}
